ORCA/M Asm65816 2.1.0

0001 9606              ****************************************************************
0002 9606              *
0003 9606              * Patch to SANE for Version 3.0 of ROM
0004 9606              *
0005 9606              * Copyright (C) 1993 Apple Computer, Inc. All Rights Reserved.
0006 9606              *
0007 9606              *
0008 9606              * System Disk 6.0.1
0009 9606              *
0010 9606              *  6-May-93 JCM - Version $0301 for 6.0.1 final. Added the Elems patch.
0011 9606              *
0012 9606              ****************************************************************
0013 9606
0014 9606              SaneVersionNum equ   $0301
0015 9606
0016 9606              ToStrip  equ   $E10184
0017 9606
0018 9606                       EXPORT Sane2CallTable 
0019 9606              Sane2CallTable PROC 
0020 9606
0021 9606                       import SaneBootInit 
0022 9606                       import SaneVersion 
0023 9606                       import ElemsPatch 
0024 9606
0025 9606              TheStart  
0026 9606 0C 00 00 00           DC L:(TheEnd-TheStart)/4
0027 960A 56 99 02 00           DC L:SaneBootInit-1
0028 960E 00 00 00 00           DC L:0                         ; SaneStartup-1'
0029 9612 00 00 00 00           DC L:0                         ; SaneShutdown-1'
0030 9616 51 99 02 00           DC L:SaneVersion-1
0031 961A 00 00 00 00           DC L:0                         ; SaneReset-1'
0032 961E 00 00 00 00           DC L:0                         ; SaneStatus-1'
0033 9622 00 00 00 00           DC L:0                         ; SaneNotImp-1'
0034 9626 00 00 00 00           DC L:0                         ; SaneNotImp-1'
0035 962A
0036 962A 00 00 00 00           DC L:0                         ; Eight16-1'
0037 962E 00 00 00 00           DC L:0                         ; DecStr-1'
0038 9632 35 99 02 00           DC L:ElemsPatch-1              ; Elems816-1
0039 9636
0040 9636              TheEnd    
0041 9636
0042 9636                       ENDP 
0043 9636
0044 9636              ****************************************************************
0045 9636              *
0046 9636              * ElemsPatch
0047 9636              *
0048 9636              * Change History
0049 9636              *
0050 9636              * 6-May-93 JCM - New for System Disk 6.0.1
0051 9636              *
0052 9636              * Corrects a problem in FXPWRI where <Src_Class was being checked to
0053 9636              * see what the integer exponent was classified as without actually having
0054 9636              * it classified. This fixes the problem with lockups in the AWGS spreadsheet.
0055 9636              *
0056 9636              ****************************************************************
0057 9636
0058 9636              ElemsPatch PROC 
0059 9636
0060 9636              Elems_Code03 equ   $FC375B              ;Elem816 entry point in ROM 03 SANE
0061 9636
0062 9636              OrigD    equ   1
0063 9636              RTL1     equ   OrigD+2
0064 9636              RTL2     equ   RTL1+3
0065 9636              OpWord   equ   RTL2+3
0066 9636              DstArg   equ   opword+2
0067 9636              SrcArg   equ   DstArg+4
0068 9636
0069 9636              SourceClass equ   $6A                   ;on SANE DP
0070 9636
0071 9636 0B                    phd   
0072 9637
0073 9637 5B                    tcd                            ;swap in SANE's DP
0074 9638
0075 9638 A3 09                 lda   OpWord,s                 ;get opword
0076 963A 29 1F 00              and   #$1F                     ;just get the operation
0077 963D C9 10 00              cmp   #$10                     ;is it FXPWRI?
0078 9640 D0 0A                 bne   @doneElemPatch           ; aparently not
0079 9642
0080 9642              * Assume that the integer exponent is normalized.
0081 9642
0082 9642 A0 00 00              ldy   #0                       ;signal normalized
0083 9645
0084 9645 A3 0F                 lda   SrcArg,s                 ;get the integer exponent so we can classify it
0085 9647 D0 01                 bne   @saveClass               ; it's already classified as normalized
0086 9649
0087 9649 88                    dey                            ;signal it's zero ($FF)
0088 964A
0089 964A 84 6A        @saveClass sty   <SourceClass           ;we overwrite Src_Sign, but it doesn't matter
0090 964C
0091 964C 7B           @doneElemPatch tdc                      ;let SANE know where its DP is
0092 964D
0093 964D 2B                    pld   
0094 964E
0095 964E 5C 5B 37 FC           jmp   >Elems_Code03            ;let SANE do all of the dirty work
0096 9652
0097 9652                       ENDP 
0098 9652
0099 9652              ****************************************************************
0100 9652              *
0101 9652              * SaneVersion
0102 9652              *
0103 9652              ****************************************************************
0104 9652
0105 9652              SaneVersion PROC 
0106 9652
0107 9652              RTL1     equ   1
0108 9652              RTL2     equ   RTL1+3
0109 9652              Result   equ   RTL2+3
0110 9652
0111 9652 A9 01 03              lda   #SaneVersionNum          ; get SANE version #
0112 9655 83 07                 sta   Result,s                 ; pass to caller
0113 9657
0114 9657              ***   v v v   fall into SaneBootInit     v v v
0115 9657
0116 9657              ****************************************************************
0117 9657              *
0118 9657              * SaneBootInit
0119 9657              *
0120 9657              ****************************************************************
0121 9657                       entry SaneBootInit 
0122 9657 A9 00 00     SaneBootInit lda   #0                   ;no error
0123 965A 18                    clc   
0124 965B 6B                    rtl   
0125 965C
0126 965C                       ENDP 
0127 965C
0128 965C                       END   
